---
generated_at: 2026-01-21 16:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Runtime Error

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00003.sql` (行1-150)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1143-1168)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行5)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは3である | E-01（行15: p_id=>3） | ○ |
| C-02 | エイリアスはRUNTIME-ERRORである | E-01（行17: p_alias=>'RUNTIME-ERROR'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | P3_QATR_IDはプライマリキーとして使用 | E-01（行80: p_is_primary_key=>true） | ○ |
| C-06 | P3_QATR_IDはHidden項目である | E-01（行87: p_display_as=>'NATIVE_HIDDEN'） | ○ |
| C-07 | P3_RUNTIME_ERRORはテキストエリアである | E-01（行102: p_display_as=>'NATIVE_TEXTAREA'） | ○ |
| C-08 | テキストエリアの高さは15行 | E-01（行104: p_cHeight=>15） | ○ |
| C-09 | P3_RUNTIME_ERRORは読み取り専用 | E-01（行107: p_read_only_when_type=>'ALWAYS'） | ○ |
| C-10 | データソースはQA_TEST_RUNSテーブル | E-01（行32: p_query_table=>'QA_TEST_RUNS'） | ○ |
| C-11 | フォーム初期化プロセスがBefore Headerで実行 | E-01（行145: p_process_point=>'BEFORE_HEADER'） | ○ |
| C-12 | CLOSEボタンはDynamic Actionでダイアログを閉じる | E-01（行64-78, 122-137） | ○ |
| C-13 | AutocompleteはOFFに設定 | E-01（行20: p_autocomplete_on_off=>'OFF'） | ○ |
| C-14 | p_handle_test_exceptionでランタイムエラーを保存 | E-02（行1143-1168） | ○ |
| C-15 | QATR_RUNTIME_ERRORカラムにエラー情報をUPDATE | E-02（行1164-1166） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_TEST_RUNS.QATR_RUNTIME_ERRORカラムのデータ型とサイズが十分か確認
- [ ] Dashboard画面からの遷移リンクが正しく設定されているか確認
- [ ] エラー情報が機密情報を含まないか確認（セキュリティ観点）
- [ ] テキストエリアの高さ（15行）がエラー表示に適切か確認
